<?php

if (function_exists('add_hook')) {
    add_hook('ShoppingCartValidateProductUpdate', 1, 'vpnresellers_checkUsername');
}

function vpnresellers_CheckUsername($vars) {

    $username = '';
    foreach ($vars['customfield'] as $varibleValue) {
        $username = $varibleValue;
        break;
    }
    $baseUrl = "https://api.vpnresellers.com/v4/accounts/check_username?username=".$username;
    $curl = curl_init();

    curl_setopt($curl, CURLOPT_CUSTOMREQUEST, 'GET');
    curl_setopt($curl, CURLOPT_URL, $baseUrl);
    curl_setopt($curl, CURLOPT_HTTPHEADER, [
        'Accept: application/json',
        'Content-Type: application/json',
    ]);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);

    $result = curl_exec($curl);

    if(! $result) {
        return 'Connection error.';
    }
    $info = curl_getinfo($curl);
    $statusCode = $info['http_code'];
    curl_close($curl);
    $result = json_decode($result);

    if ($statusCode === 422) {
        if (isset($result->errors)) {
            foreach ($result->errors as $error) {
                if (isset($error[0]) && $error[0] !== "The username field is required.") {
                    return $error[0];
                }

                if ($error[0] === "The username field is required.") {
                  return $username;
                }
            }
        }
        return 'Validation error';
    }
}